<?php


/**
 * 打印数据
 * @param string $name 数据
 * @return mixed
 */
if (!function_exists('dd')) {
    function dd($data)
    {
        //可安装composer包
        //composer require hellonico/timber-dump-extension
        dump($data);
        exit();
    }
}

/**
 * @param $data 数据
 * @param $where 判断条件 格式为['判断字段','判断条件','判断值']
 * @return bool|void
 */
if (!function_exists('yc_where_data')){
    function yc_where_data($data = [],$where = []): bool
    {
        if (empty($data) || empty($where) || !isset($data[$where[0]])){
            return false;
        }
        if ($where[1] == '==')return ($data[$where[0]] == $where[2]);
        if ($where[1] == '===')return ($data[$where[0]] === $where[2]);
        if ($where[1] == '!=')return ($data[$where[0]] != $where[2]);
        if ($where[1] == '<>')return ($data[$where[0]] <> $where[2]);
        if ($where[1] == '!==')return ($data[$where[0]] !== $where[2]);
        if ($where[1] == '<')return ($data[$where[0]] < $where[2]);
        if ($where[1] == '>')return ($data[$where[0]] > $where[2]);
        if ($where[1] == '>=')return ($data[$where[0]] >= $where[2]);
        if ($where[1] == '<=')return ($data[$where[0]] <= $where[2]);
        return false;
    }
}



/**
 * 获取树状栏目数据
 * @param $file_name 文件名
 * @param $where 数据判断条件 格式为[['判断字段','判断条件','判断值']['name','==','张三']] 仅父级判断
 * @return array|mixed
 * @throws Exception
 */
if (!function_exists('yc_file_get_contents')) {
    function yc_file_get_contents($file_name = '',$where = [],$data = [],$son = 'son')
    {
        if (empty($file_name))$file_name = 'tree_category.php';
        if (empty($data)){
            $file_url = ADDON_PATH . 'yccms' . DS . 'config' . DS . $file_name;
            if (!file_exists($file_url)) return [];
            $data = include $file_url;
        }
        if ($where){
            $res_data = [];
            foreach ($data??[] as $item){
                //判断条件
                $wh_bool = true;
                foreach ($where as $wh){
                    if (!yc_where_data($item,$wh)){
                        $wh_bool = false;
                    }
                }
                //如果条件都符合 追加数据
                if ($wh_bool){
                    //递归查询子集数据
                    if (!empty($item[$son]) && is_array($item[$son])){
                        //查询子集
                        $item[$son] = yc_file_get_contents($file_name,$where,$item[$son],$son);
                    }
                    $res_data[] = $item;
                }

            }
            if ($res_data)return $res_data;
        }
        return $data;
    }
}


/**
 * 获取单页、列表页、详情页的url
 * @param $data 栏目数据或详情数据
 * @param $argument 伪静态参数
 * @param $stu 状态 1=列表页、2=详情页（在跳转详情页的时候设置为2）
 * @param $suffix 是否生成后缀，默认为true
 * @param $domain 域名，默认不包含域名
 * @return bool|string
 * @throws Exception
 */
if (!function_exists('yc_addon_url')) {
    function yc_addon_url($data = [],$argument = [],$stu = 1,$suffix = true,$domain = false){
        //如果是获取详情页url 那么传过来的数据是列表数据
        if ($stu == 2){
            $list_data = $data;
            $data = yc_recursion_one_data('',[['id','==',$list_data['yccms_category_id']]]);
        }
        $url = '';
        //外链类型
        if (!isset($data['status']) || ($data['status'] == 3))return '';
        $name = $data['status'] == 1?'single':'rule';
        $file_data = yc_recursion_one_data($name.'.php',[['id','==',$data['yccms_'.$name.'_id']]]);
        if (empty($file_data))return '';
        //单页类型
        if ($data['status'] == 1){
            $url = 'yccms/single.' . $file_data['identification_zh'] . '/index';
            if (!isset($argument[':cid']))$argument[':cid'] = $data['id'];
        }
        //获取列表数据
        if ($data['status'] == 2){
            $foo_name = $stu == 2?'/details':'/index';
            $url = 'yccms/rule_list.' . $file_data['identification_zh'] . $foo_name;
            //列表类型 列表夜
            if ($stu == 1){
                if (!isset($argument[':cid']))$argument[':cid'] = $data['id'];
            }
            //列表类型 详情页
            if ($stu == 2){
                if (!isset($argument[':cid']))$argument[':cid'] = $data['id'];
                if (!isset($argument[':id']))$argument[':id'] = $list_data['id'];
            }
        }
        if (!empty($url)){
            $url = addon_url($url,$argument,$suffix,$domain);
        }
        return $url;
    }
}


/**
 * 递归查询首页
 * @param string $data 栏目数据
 * @return mixed
 */
if (!function_exists('yc_is_index')) {
    function yc_is_index($data = []){
        if (empty($data))$data = yc_file_get_contents();
        if (isset($data) && !empty($data)){
            foreach ($data as $item){
                if ($item['status'] == 1){
                    $single = yc_recursion_one_data('single.php',[['id','==',$item['yccms_single_id']]]);
                    if ($single['is_home'] == 1){
                        //伪静态
                        $item['pseudo-static'] = "yccms/single.".$single['identification_zh']."/index";
                        return $item;
                    }
                }
                if (isset($item['son']) && !empty($item['son']) && is_array($item['son'])){
                    $this_data = yc_is_index($item['son']);
                    if ($this_data)return $this_data;
                }
            }
        }
    }
}

/**
 * 递归查询多条数据
 * @param $data 数据
 * @param $where 数据判断条件 格式为[['判断字段','判断条件','判断值']['name','==','张三']]
 * @param $son 子集字段名
 * @param $no_son 删除子集
 * @return array
 * @throws Exception
 */
if (!function_exists('yc_recursion_data')) {
    function yc_recursion_data($data,$where = [],$son = 'son',$no_son = false): array
    {
        $res_data = [];
        //默认查询栏目数据
        if (empty($data) || is_string($data)){
            $data = yc_file_get_contents(is_string($data)?$data:'');
        }
        foreach ($data??[] as $item){
            //判断条件
            $wh_bool = true;
            foreach ($where as $wh){
                if (!yc_where_data($item,$wh)){
                    $wh_bool = false;
                }
            }
            //如果条件都符合 追加数据
            if ($wh_bool){
                $in_data = $item;
                //如果需要删除子集
                if (isset($in_data[$son]) && $no_son)unset($in_data[$son]);
                $res_data[] = $in_data;
            }
            //递归查询子集数据
            if (!empty($item[$son]) && is_array($item[$son])){
                //查询子集
                $res =  yc_recursion_data($item[$son],$where,$son,$no_son);
                foreach ($res??[] as $val){
                    $res_data[] = $val;
                }
            }
        }
        return $res_data;
    }
}






/**
 * 递归查询单条数据
 * @param $data 数据
 * @param $where 数据判断条件 格式为[['判断字段','判断条件','判断值']['name','==','张三']]
 * @param $son 子集字段名
 * @param $no_son 删除子集
 * @return array
 * @throws Exception
 */
if (!function_exists('yc_recursion_one_data')) {
    function yc_recursion_one_data($data,$where = [],$son = 'son',$no_son = false): array
    {
        $res = yc_recursion_data($data,$where,$son,$no_son);
        return $res[0]??[];
    }
}

/**
 * 判断当前数据栏目是当前栏目或当前栏目的pid
 * @return bool
 */
if (!function_exists('yc_is_current')) {
    function yc_is_current(array $data): bool
    {
        $cid = (int) input('param.cid');
        //如果没有cid 则是首页 直接返回true
        if (empty($cid) && ($data['status'] == 1)){
            $single = yc_recursion_one_data('single.php',[['id','==',$data['yccms_single_id']]],'son',true);
            if (isset($single['is_home']) && $single['is_home'])return true;
            return false;
        }else{
            if ($data['id'] == $cid)return true;
            $this_d = yc_recursion_one_data([],[['id','==',$cid]]);
            if (!empty($this_d['pid']) && ($this_d['pid'] == $data['id']))return true;
            if (!empty($this_d['pid'])){
                $parent_d = yc_recursion_one_data([],[['id','==',$this_d['pid']]]);
                if (!empty($parent_d['pid']) && ($parent_d['pid'] == $data['id']))return true;
            }
            return false;
        }
    }
}



/**
 * 获取配置项数据
 */
if (!function_exists('yc_get_config')) {
    function yc_get_config($name = '')
    {
        $config = yc_file_get_contents('config.php');
        if (empty($config))return '';
        return $config[$name]??'';
    }
}



/**
 * 生成翻译地址
 * @param $lang 请参考 https://ai.youdao.com/DOCSIRMA/html/trans/api/wyfy/index.html#section-10 《支持语言》
 */
if (!function_exists('yc_lang')) {
    function yc_lang($lang = '')
    {
        $url = request()->baseFile() == "/index.php"?request()->url():'javascript:;';
        return "/addons/yccms/index/lang_set?yc_lang=$lang&yc_url=$url";
    }
}

/**
 * 获取文件名
 */
if (!function_exists('yc_get_filename')) {
    function yc_get_filename($file_path)
    {
        //1、先获取带文件部分
        $file_base_name = basename($file_path);
        //2、查找截取即可
        $f_name = substr($file_base_name, 0, strrpos($file_base_name, '.'));
        return $f_name;
    }
}


